//
//  NSURLCredential+RWPrivateKeyAdditions.h
//  RapidWeaver
//
//  Created by Keith Duncan on 22/05/2013.
//  Copyright (c) 2013 Realmac Software. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface RMFTPURLCredential : NSObject

@property (readonly, copy, nonatomic) NSString *user;

@end

@interface RMFTPURLCredential (RMFTPPasswordAuthentication)

+ (id)credentialWithUser:(NSString *)user password:(NSString *)password;

@property (readonly, copy, nonatomic) NSString *password;

@property (readonly, nonatomic) BOOL hasPassword;

@end

@interface RMFTPURLCredential (RMFTPPublicKeyAuthentication)

+ (id)credentialWithUser:(NSString *)user contentsOfPrivateKey:(NSURL *)privateKeyLocation publicKey:(NSURL *)publicKeyLocation passphrase:(NSString *)passphrase;
+ (id)credentialWithLocalFolderURL:(NSURL *)localFolderURL;

@property (readonly, copy, nonatomic) NSURL *privateKeyLocation;
@property (readonly, copy, nonatomic) NSURL *publicKeyLocation;

@property (readonly, copy, nonatomic) NSString *passphrase;
@property (readonly, copy, nonatomic) NSURL *localFolderURL;

@property (readonly, nonatomic) BOOL hasPrivateKey;
@property (readonly, nonatomic) BOOL isLocalFolderLocation;

/*!
	\brief
	Atomically starts accessing all resources, if NO is returned none of the resources are available and `stopAccessingSecurityScopedResource` MUST NOT be called
 */
- (BOOL)startAccessingSecurityScopedResource:(NSError **)errorRef;

/*!
	\brief
	Must only be called if `startAccessingSecurityScopedResource:` returned YES
 */
- (void)stopAccessingSecurityScopedResource;

@end
